/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

final class RTImage
extends PrismImage
implements ResourceFactoryListener {
    private RTTexture txt;
    private final int width;
    private final int height;
    private boolean listenerAdded = false;
    private ByteBuffer pixelBuffer;
    private float pixelScale;

    RTImage(int n2, int n3, float f2) {
        this.width = n2;
        this.height = n3;
        this.pixelScale = f2;
    }

    @Override
    Image getImage() {
        return Image.fromByteBgraPreData((ByteBuffer)this.getPixelBuffer(), (int)this.getWidth(), (int)this.getHeight());
    }

    @Override
    Graphics getGraphics() {
        Graphics graphics = this.getTexture().createGraphics();
        graphics.transform(PrismGraphicsManager.getPixelScaleTransform());
        return graphics;
    }

    private RTTexture getTexture() {
        if (this.txt == null) {
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            this.txt = resourceFactory.createRTTexture((int)Math.ceil((float)this.width * this.pixelScale), (int)Math.ceil((float)this.height * this.pixelScale), Texture.WrapMode.CLAMP_NOT_NEEDED);
            this.txt.contentsUseful();
            this.txt.makePermanent();
            if (!this.listenerAdded) {
                resourceFactory.addFactoryListener((ResourceFactoryListener)this);
                this.listenerAdded = true;
            }
        }
        return this.txt;
    }

    @Override
    void draw(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.txt == null && graphics.getCompositeMode() == CompositeMode.SRC_OVER) {
            return;
        }
        if (graphics instanceof PrinterGraphics) {
            int n10 = n8 - n6;
            int n11 = n9 - n7;
            IntBuffer intBuffer = IntBuffer.allocate(n10 * n11);
            PrismInvoker.runOnRenderThread(() -> this.getTexture().readPixels((Buffer)intBuffer));
            Image image = Image.fromIntArgbPreData((IntBuffer)intBuffer, (int)n10, (int)n11);
            Texture texture = graphics.getResourceFactory().createTexture(image, Texture.Usage.STATIC, Texture.WrapMode.CLAMP_NOT_NEEDED);
            graphics.drawTexture(texture, (float)n2, (float)n3, (float)n4, (float)n5, 0.0f, 0.0f, (float)n10, (float)n11);
            texture.dispose();
        } else if (this.txt == null) {
            Paint paint = graphics.getPaint();
            graphics.setPaint((Paint)Color.TRANSPARENT);
            graphics.fillQuad((float)n2, (float)n3, (float)n4, (float)n5);
            graphics.setPaint(paint);
        } else {
            graphics.drawTexture((Texture)this.txt, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6 * this.pixelScale, (float)n7 * this.pixelScale, (float)n8 * this.pixelScale, (float)n9 * this.pixelScale);
        }
    }

    @Override
    void dispose() {
        PrismInvoker.invokeOnRenderThread(() -> {
            if (this.txt != null) {
                this.txt.dispose();
                this.txt = null;
            }
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        boolean bl = false;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            if (this.pixelBuffer != null) {
                this.pixelBuffer.order(ByteOrder.nativeOrder());
                bl = true;
            }
        }
        if (bl || this.isDirty()) {
            PrismInvoker.runOnRenderThread(() -> {
                this.flushRQ();
                if (this.txt != null && this.pixelBuffer != null) {
                    Object object;
                    PixelFormat pixelFormat = this.txt.getPixelFormat();
                    if (pixelFormat != PixelFormat.INT_ARGB_PRE && pixelFormat != PixelFormat.BYTE_BGRA_PRE) {
                        throw new AssertionError((Object)("Unexpected pixel format: " + pixelFormat));
                    }
                    RTTexture rTTexture = this.txt;
                    if (this.pixelScale != 1.0f) {
                        object = GraphicsPipeline.getDefaultResourceFactory();
                        rTTexture = object.createRTTexture(this.width, this.height, Texture.WrapMode.CLAMP_NOT_NEEDED);
                        Graphics graphics = rTTexture.createGraphics();
                        graphics.drawTexture((Texture)this.txt, 0.0f, 0.0f, (float)this.width, (float)this.height, 0.0f, 0.0f, (float)this.width * this.pixelScale, (float)this.height * this.pixelScale);
                    }
                    this.pixelBuffer.rewind();
                    object = rTTexture.getPixels();
                    if (object != null) {
                        this.pixelBuffer.asIntBuffer().put((int[])object);
                    } else {
                        rTTexture.readPixels((Buffer)this.pixelBuffer);
                    }
                    if (rTTexture != this.txt) {
                        rTTexture.dispose();
                    }
                }
            });
        }
        return this.pixelBuffer;
    }

    @Override
    protected void drawPixelBuffer() {
        PrismInvoker.invokeOnRenderThread(new Runnable(){

            @Override
            public void run() {
                Graphics graphics = RTImage.this.getGraphics();
                if (graphics != null && RTImage.this.pixelBuffer != null) {
                    RTImage.this.pixelBuffer.rewind();
                    Image image = Image.fromByteBgraPreData((ByteBuffer)RTImage.this.pixelBuffer, (int)RTImage.this.width, (int)RTImage.this.height);
                    Texture texture = graphics.getResourceFactory().createTexture(image, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_NOT_NEEDED);
                    graphics.clear();
                    graphics.drawTexture(texture, 0.0f, 0.0f, (float)RTImage.this.width, (float)RTImage.this.height);
                    texture.dispose();
                }
            }
        });
    }

    public void factoryReset() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    public void factoryReleased() {
    }

    @Override
    public float getPixelScale() {
        return this.pixelScale;
    }
}

